<?php
// Configuration file paths
$dbInfoFile = 'pages/dbInfo.php';
$configFile = 'auth/config.php';

// Check if the setup has been done
if (!file_exists($dbInfoFile) || !file_exists($configFile)) {
    header('Location: install.php');
    exit;
}

// If setup is done, include the database connection file
include 'pages/dbInfo.php';

// You can now use the connect_database function if needed
$con = connect_database();

// Now you can display your index page content
include 'auth/function.php';


?>

<!DOCTYPE html>
<html lang="zxx">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>chuimei-pe - 0% FEE, Fast & Safe UPI Payment API</title>
  <!-- favicon  -->
  <link rel="shortcut icon" href="myassets/images/favicon.png" type="image/x-icon">
  <!-- faremwork of css -->
  <link rel="stylesheet" href="myassets/css/bootstrap.min.css">
  <!-- style sheet of css -->
  <link rel="stylesheet" href="myassets/css/style.css">
  <!-- Responsive sheet of css -->
  <link rel="stylesheet" href="myassets/css/responsive.css">
  <!-- fonts awsome icon link  -->
  <link rel="stylesheet" href="myassets/css/font-awesome.min.css">
  <!-- slick-slider link css -->
  <link rel="stylesheet" href="myassets/css/slick.min.css">
  <!-- animation of css -->
  <link rel="stylesheet" href="myassets/css/aos.css">
</head>

<body>

  <div class="site-wrapper">
    <!-- ======== 1.1. Header section ======== -->
    <header>
      <nav class="navbar navbar-expand-lg container pt-lg-4 pt-3 pb-lg-4 pb-3">
        <div class="container-fluid justify-content-lg-start justify-content-between">
          <!-- site logo -->
          <a class="nav-logo p-0" href="#">
            <figure><img loading="lazy" src="<?php echo $site_settings['logo_url']; ?>" alt="logo"></figure>
          </a>
          <!-- navigation button  -->
          <div class="d-flex gap-3 flex-row-reverse">
            <button class="open-aside" onclick="open_aside()" type="button">
              <i class="fa-solid fa-bars"></i>
            </button>
            <!-- navigation bar manu  -->
            <div class="d-flex justify-content-between gap-xl-4 gap-lg-3 w-100 align-items-center">
              <div class="collapse navbar-collapse " id="navbarSupportedContent">
                <ul
                  class="navbar-nav d-flex justify-content-center align-items-center gap-lg-4 gap-md-3 gap-sm-2 gap-2 mb-2 mb-lg-0">
                  <li class="nav-item">
                    <a class="nav-link active" href="#">Home</a>
                  </li>
                  <li class="nav-item">
                    <a class="nav-link" href="#about">About</a>
                  </li>
                  <li class="nav-item">
                    <a class="nav-link" href="#features">Features</a>
                  </li>
                  <li class="dropdown">
                    <a class="nav-link d-flex align-item-center gap-1">Useful Link<i
                        class="fa-sharp fa-solid fa-sort-down"></i></a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="#">APi Documentation</a></li>
                      <li>
                        <a class="dropdown-item" href="#">Postmain Docs</a>
                      </li>
                      <li><a class="dropdown-item" href="">Privacy Policy</a></li>
                      <li><a class="dropdown-item" href="">Refund Policy</a></li>
                      <li>
                        <a class="dropdown-item" href="">Term & Condition</a>
                      </li>
                    </ul>
                  </li>
                </ul>
              </div>
              <div class="search SearchModal">
                <a href="#">
                  <i class="fa-solid fa-magnifying-glass"></i>
                </a>
              </div>
              <div>
                <a href="auth/index" class="hover1 down-btn" id="getStartedAnchor">Login / Register</a>
              </div>
            </div>
          </div>
        </div>
      </nav>
      <div class="modal searchModal">
        <button class="close-btn d-flex" onclick="closeSearchModal()">&times;</button>
        <div class="position-relative d-flex align-items-center justify-content-center ">
          <input type="text" placeholder="Search..." name="search">
          <button class="search-btn">
            <img loading="lazy" src="myassets/images/icons/search.svg" alt="search">
          </button>
        </div>
      </div>
      <!--===== aside navigation slidebar =====-->
      <aside>
        <div id="mySidenav" class="right-sidbar">
          <div class="side-nav-logo d-flex justify-content-between align-items-center ps-2 pe-1 nav-logo">
            <figure class="navbar-brand">
              <a href="index">
                <img loading="lazy" src="<?php echo $site_settings['logo_url']; ?>" alt="Logo">
              </a>
            </figure>
            <button class="fa-solid fa-xmark" onclick="close_aside()"></button>
          </div>
          <ul class="pt-4">
            <li class="nav-item">
                <a class="nav-link active" href="#">Home</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" href="#about">About</a>
              </li>
              <li class="nav-item">
                <a class="nav-link" href="#features">Features</a>
              </li>
              <li class="nav-item">
                <a href="register">Register</a>
              </li>
              <li class="nav-item">
                <a href="auth/index">Login</a>
              </li>
    
              </ul>
            </li>
          </ul>
        </div>
      </aside>
    </header>
    <!-- ======== End of 1.1. Header section ======== -->    <!-- ======== 1.2. Hero section ========  -->
    <section class="Hero">
      <div class="container">
        <div class="row">
          <div class="col-lg-6">
            <div class="d-flex flex-column" data-aos="fade-up">
              <div>
                <h1>The Ultimate <span>UPI Payment</span> Solution</h1>
                <p>Accept Payments Directly to your Bank Account At 0% Transaction Fee. Easy To Use ! Wordpress Website ! Android App ! All Website</p>
                <div class="my-lg-2 my-md-3">
                  <a href="register" class="hover2">
                    Get Started
                  </a>
                </div>
              </div>
              <div class="mt-1">
                <h5>Over <span class="number" data-final-value="5000"></span>+ Reviews</h5>
                <div class="d-flex">
                  <figure><img loading="lazy" src="myassets/images/reviewImg_1.webp" alt="reviewImg_1"></figure>
                  <figure><img loading="lazy" src="myassets/images/reviewImg_2.webp" alt="reviewImg_2"></figure>
                  <figure><img loading="lazy" src="myassets/images/reviewImg_3.webp" alt="reviewImg_3"></figure>
                  <div class="rounded-circle d-flex justify-content-center align-items-center position-relative">
                    <h5 class="p-0 ps-1"><span class="number" data-final-value="5"></span>K+</h5>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="position-relative d-flex flex-lg-row flex-column h-100" style="align-items: center; width: 100%;">
              <figure class="position-absolute" data-aos="zoom-in-up"><img loading="lazy" src="myassets/images/upi.svg"
                  alt="credit_cards">
              </figure>
              <div class="d-flex flex-lg-column align-items-end w-100" data-aos="fade-down">
                <div class="pe-lg-3">
                  <h2><span class="number" data-final-value="93"></span>k+</h2>
                  <p>Satisfied user</p>
                </div>
                <div class="pe-lg-1">
                  <h2><span class="number" data-final-value="4.9"></span>/5</h2>
                  <p>Client Rating</p>
                </div>
                <div class="pe-lg-3">
                  <h2><span class="number" data-final-value="99"></span>%</h2>
                  <p>Secure Payments</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- ======== End of 1.2. Hero section ========  -->
    <!-- ======== 1.3. Partners section ======== -->
    <section class="Partners" id="about">
      <div class="container">
        <div class="d-flex gap-3 align-items-center">
          <hr class="flex-grow-1">
          <h5>Our Solution Partners</h5>
          <hr class="flex-grow-1">
        </div>
      </div>
      <div class="PartnersSlider" data-aos="zoom-in">
        <div>
          <a href="#">
            <img loading="lazy" src="myassets/images/icons/logo-smarthub.svg" alt="partner1">
          </a>
        </div>
        <div>
          <a href="#">
            <img loading="lazy" src="myassets/images/icons/sbi.png" alt="partner2">
          </a>
        </div>
        <div>
          <a href="#">
            <img loading="lazy" src="myassets/images/icons/Amazon_Pay_logo.svg.png" alt="partner3">
          </a>
        </div>
        <div>
          <a href="#">
            <img loading="lazy" src="myassets/images/icons/freecharge.png" alt="partner4">
          </a>
        </div>
        <div>
          <a href="#">
            <img loading="lazy" src="myassets/images/icons/phonepe.png" alt="partner5">
          </a>
        </div>
        <div>
          <a href="#">
            <img loading="lazy" src="myassets/images/icons/paytm.png" alt="partner6">
          </a>
        </div>
        <div>
          <a href="#">
            <img loading="lazy" src="myassets/images/icons/bharatpay.png" alt="partner7">
          </a>
        </div>
        <div>
          <a href="#">
            <img loading="lazy" src="myassets/images/icons/mobikwik.png" alt="partner8">
          </a>
        </div>
      </div>
    </section>
    <!-- ======== End of 1.3. Partners section ======== -->
    <!-- ======== 1.4. Services section ======== -->
    <section class="Services">
      <div class="container">
        <div class="row">
          <div class="col-lg-6">
            <div class="d-flex flex-wrap pt-lg-0 pt-5">
              <div class="d-flex align-items-center gap-3" data-aos="flip-left">
                <figure>
                  <img loading="lazy" src="myassets/images/icons/investment.svg" alt="icon3">
                </figure>
                <div class="d-flex flex-column gap-2">
                  <h5>0% Transaction Charge</h5>
                  <p>No charges of any kind will be deducted for <?php echo $site_settings['brand_name']; ?> Payments</p>
                </div>
              </div>
              <div class="d-flex align-items-center gap-3" data-aos="flip-left">
                <figure>
                  <img loading="lazy" src="myassets/images/icons/card.svg" alt="icon4">
                </figure>
                <div class="d-flex flex-column gap-2">
                  <h5>Fast Transactions</h5>
                  <p><?php echo $site_settings['brand_name']; ?> Payment process payments like a rocket.</p>
                </div>
              </div>
              <div class="d-flex align-items-center gap-3" data-aos="flip-left">
                <figure>
                  <img loading="lazy" src="myassets/images/icons/person.svg" alt="icon1">   
                </figure>
                <div class="d-flex flex-column gap-2">
                  <h5>Developer Friendly</h5>
                  <p>You can easily integrate <?php echo $site_settings['brand_name']; ?> Payment API.</p>
                </div>
              </div>
              <div class="d-flex align-items-center gap-3" data-aos="flip-left">
                <figure>
                  <img loading="lazy" src="myassets/images/icons/transaction.svg" alt="icon2">
                </figure>
                <div class="d-flex flex-column gap-2">
                  <h5>Support</h5>
                  <p><?php echo $site_settings['brand_name']; ?> Payment offers dedicated WhatsApp support.</p>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="d-flex flex-column h-100 position-relative" data-aos="fade-up">
              <h2>
                Your Money, Your Way, <span>Our Guarantee</span>
              </h2>
              <p class="py-4 flex-grow-1"><?php echo $site_settings['brand_name']; ?> Payment API does not hold your money for even a second, it provides you the service of instant settlement so that your money remains safe. So do not delay, register immediately on <?php echo $site_settings['brand_name']; ?> Payment API and use our very advanced features.</p>
              <div>
                <a href="register" class="hover2">Get Started</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- ======== End of 1.4. Services section ======== -->
    <br><br><br><br><br>

    <!-- ========  1.5. Registration section ========  -->
    <section class="Registration" id="features">
      <div class="container">
        <div class="row gy-lg-0 gy-md-5 gy-4">
          <div class="col-lg-6">
            <div class="mt-md-4" data-aos="fade-up">
              <h2>Our Easy Steps For <span>Registration</span></h2>
              <p><?php echo $site_settings['brand_name']; ?> Payment API is a secure, fast, and user-friendly platform that simplifies digital transactions. Whether you're a business owner or an individual user, <?php echo $site_settings['brand_name']; ?> offers an all-in-one solution for managing your financial activities with ease.</p>
              <div class="d-flex gap-sm-5  gap-4 flex-sm-row flex-column">
                <ul class="d-flex flex-column">
                  <li>
                    <h6>Instant Payment Processing</h6>
                  </li>
                  <li>
                    <h6>High-Level Data Encryption</h6>
                  </li>
                  <li>
                    <h6>Enjoy Full Access</h6>
                  </li>
                </ul>
                <ul class="d-flex flex-column">
                  <li>
                    <h6>Real-time Transaction Tracking</h6>
                  </li>
                  <li>
                    <h6>Easy Integration for Businesses</h6>
                  </li>
                  <li>
                    <h6>Your Own Branding</h6>
                  </li>
                </ul>
              </div>
              <div class="d-flex  align-items-center gap-md-4 gap-3">
                <div>
                  <a href="register" class="hover1">Register Now</a>
                </div>
                <div>
                  <a href="auth/index" class="hover2">Login</a>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="d-flex justify-content-lg-start justify-content-center">
              <figure class="position-relative" data-aos="zoom-in-up" data-aos-delay="200">
                <img loading="lazy" src="myassets/images/card2.png" class="w-100" alt="registration_mobile"
                  data-aos="fade-up">
              </figure>
              <div class="d-flex flex-column gap-lg-4 gap-3 ps-lg-4 ps-3 pt-lg-2">
                <div class="d-flex flex-column gap-lg-3" data-aos="flip-left">
                  <figure class="d-flex justify-content-center align-items-center">
                    <img loading="lazy" src="myassets/images/icons/income_icon.svg" alt="income_icon">
                  </figure>
                  <div>
                    <p class="p-0">Incomes</p>
                    <p class="pt-1">₹ <span class="number" data-final-value="2750.50"></span></p>
                  </div>
                </div>
                <div class="d-flex flex-column gap-lg-3" data-aos="flip-left">
                  <figure class="d-flex justify-content-center align-items-center"><img
                      src="myassets/images/icons/icon_expenses.svg" alt="icon_expenses"></figure>
                  <div>
                    <p class="p-0">Expenses</p>
                    <p class="pt-1">₹ <span class="number" data-final-value="1240.75"></span></p>
                  </div>
                </div>
                <figure data-aos="flip-left">
                  <img loading="lazy" src="myassets/images/monthly_Graph.webp" class="w-100" alt="monthly_Graph">
                </figure>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- ======== End of 1.5. Registration section ========  -->

<!-- ======== 1.8. Testimonials section (IMB Payment API) ======== -->
<section class="Testimonials">
    <div class="container">
      <div class="row">
        <!-- Left Content Section -->
        <div class="col-md-6 col-lg-6">
          <div class="d-flex flex-column gap-4 h-100 justify-content-center position-relative" data-aos="fade-up">
            <h2>What Our Clients Say About <?php echo $site_settings['brand_name']; ?></h2>
            <p><?php echo $site_settings['brand_name']; ?> Payment API has earned the trust of thousands of businesses across India. Here’s what our users are saying about their experience with our platform.</p>
            <div class="d-flex flex-row">
              <div class="d-flex flex-column">
                <h3><span class="number" data-final-value="93"></span>k+</h3>
                <p>Trusted Businesses</p>
              </div>
              <div class="d-flex flex-column">
                <h3><span class="number" data-final-value="4.9"></span>/5</h3>
                <p>User Rating</p>
              </div>
              <div class="d-flex flex-column">
                <h3><span class="number" data-final-value="100"></span>k+</h3>
                <p>Successful Integrations</p>
              </div>
            </div>
          </div>
        </div>
  
        <!-- Right Testimonials Section -->
        <div class="col-md-6 col-lg-6">
          <div class="d-flex flex-column ps-lg-5 justify-content-between pt-5 pt-md-0">
  
            <!-- Testimonial 1 -->
            <div class="d-flex gap-4 align-items-center position-relative" data-aos="fade-up">
              <figure class="position-absolute">
                <img loading="lazy" src="myassets/images/icons/comma.svg" alt="comma">
              </figure>
              <figure>
                <img loading="lazy" src="myassets/images/testimonial_1.webp" alt="Ravi Mehta">
              </figure>
              <div class="d-flex flex-column gap-1">
                <div>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                </div>
                <div class="py-md-1">
                  <h6>Ravi Mehta</h6>
                  <p>Founder, QuickKart</p>
                </div>
                <p class="p-0">"<?php echo $site_settings['brand_name']; ?>'s seamless integration and real-time dashboard helped us scale our business effortlessly. Transactions are fast and secure!"</p>
              </div>
            </div>
  
            <!-- Testimonial 2 -->
            <div class="d-flex gap-4 align-items-center position-relative" data-aos="fade-up">
              <figure class="position-absolute">
                <img loading="lazy" src="myassets/images/icons/comma.svg" alt="comma">
              </figure>
              <figure>
                <img loading="lazy" src="myassets/images/reciever.webp" alt="Shweta Kapoor">
              </figure>
              <div class="d-flex flex-column gap-1">
                <div>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                </div>
                <div class="py-md-1">
                  <h6>Shweta Kapoor</h6>
                  <p>Developer, FinBox</p>
                </div>
                <p class="p-0">"The developer-friendly API and excellent documentation made integration smooth. <?php echo $site_settings['brand_name']; ?>'s support team is always responsive!"</p>
              </div>
            </div>
  
            <!-- Testimonial 3 -->
            <div class="d-flex gap-4 align-items-center position-relative" data-aos="fade-up">
              <figure class="position-absolute">
                <img loading="lazy" src="myassets/images/icons/comma.svg" alt="comma">
              </figure>
              <figure>
                <img loading="lazy" src="myassets/images/testimonial_3.webp" alt="Aman Jain">
              </figure>
              <div class="d-flex flex-column gap-1">
                <div>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                  <i class="fa-solid fa-star"></i>
                </div>
                <div class="py-1">
                  <h6>Aman Jain</h6>
                  <p>Freelancer</p>
                </div>
                <p class="p-0">"With <?php echo $site_settings['brand_name']; ?>, I can easily accept payments from my clients. The transparent pricing and instant settlements are a big plus!"</p>
              </div>
            </div>
  
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- ======== End of 1.8. Testimonials section ======== -->
  <br><br><br><br><br>

    <!-- ======== 1.7. Benefits section ======== -->
    <section class="Benefits">
      <div class="container">
        <div class="row">
          <div class="col-lg-5">
            <figure class="position-relative pt-5 pt-lg-0" data-aos="zoom-in-up">
              <img loading="lazy" src="myassets/images/card2.png" class="w-100" alt="mobile">
            </figure>
          </div>
          <div class="col-lg-7">
            <div
              class="d-flex flex-column h-100 gap-md-5 gap-4 justify-content-between justify-content-xl-start pb-lg-0 pb-5"
              data-aos="fade-up">
              <h2>You Can Receive Money On Your <span>Finger Tips</span></h2>
              <div class="d-flex gap-0 position-relative">
                <div class="d-flex flex-column gap-5">
                  <div class="d-flex flex-column gap-3">
                    <h5>John Smith Sending</h5>
                    <div class="d-flex gap-4 align-items-center">
                      <figure>
                        <img loading="lazy" src="myassets/images/sender.webp" alt="sender">
                      </figure>
                      <p>₹ <span class="number" data-final-value="466.53"></span></p>
                    </div>
                  </div>
                  <div class="d-flex flex-column gap-3">
                    <h5>William Recieving</h5>
                    <div class="d-flex gap-4 align-items-center">
                      <figure>
                        <img loading="lazy" src="myassets/images/reciever.webp" alt="reciever">
                      </figure>
                      <p>₹ <span class="number" data-final-value="466.53"></span></p>
                    </div>
                  </div>
                </div>
                <div class="d-flex flex-column py-4">
                  <figure>
                    <img loading="lazy" src="myassets/images/icons/indian.png" alt="flag">
                  </figure>
                  <figure class="d-flex align-items-center justify-content-center">
                    <img loading="lazy" src="myassets/images/icons/telegram.png" alt="telegram">
                  </figure>
                  <figure>
                    <img loading="lazy" src="myassets/images/icons/indian.png" alt="flag">
                  </figure>
                </div>
                <div class="position-absolute p-4 d-flex align-items-center gap-3">
                  <div>
                    <figure>
                      <i class="fa-solid fa-check"></i>
                    </figure>
                  </div>
                  <p>Your Payment has been successful</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- ======== End of 1.7. Benefits section ======== -->

<!-- ======== End of 1.10. Blog section ======== -->
<br><br><br><br><br>
    <!-- ======== 1.11. FAQs section (IMB Payment API) ======== -->
<section class="FAQs">
  <div class="container">
    <div class="row">
      <div class="col-md-6 col-lg-7">
        <div data-aos="fade-up">
          <h2>Frequently Asked <span>Questions</span></h2>
          <p><?php echo $site_settings['brand_name']; ?> Payment API is a secure and efficient solution for processing online transactions. Here are some frequently asked questions to help you understand how it works.</p>
          <div>
            <div class="accordion accordion-flush d-flex flex-column" id="accordionExample">
              
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button class="accordion-button" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                    What is <?php echo $site_settings['brand_name']; ?> Payment API?
                  </button>
                </h2>
                <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    <p><?php echo $site_settings['brand_name']; ?> Payment API is an online payment processing platform that allows businesses to accept credit/debit cards, UPI, net banking, and digital wallets securely.</p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                    Is <?php echo $site_settings['brand_name']; ?> Payment API secure?
                  </button>
                </h2>
                <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    <p>Yes, <?php echo $site_settings['brand_name']; ?> Payment API uses advanced encryption and is PCI-DSS compliant to ensure all transactions are safe and secure.</p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                    How long does it take to settle payments?
                  </button>
                </h2>
                <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    <p>Typically, settlements are done within T+1 working days, where 'T' is the transaction date.</p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                    What payment methods are supported?
                  </button>
                </h2>
                <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    <p><?php echo $site_settings['brand_name']; ?> supports multiple payment methods including credit cards, debit cards, UPI, net banking, and wallets like Paytm, PhonePe, and Google Pay.</p>
                  </div>
                </div>
              </div>

              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                    How can I integrate <?php echo $site_settings['brand_name']; ?> Payment API on my website?
                  </button>
                </h2>
                <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                  <div class="accordion-body">
                    <p>You can integrate it easily using <?php echo $site_settings['brand_name']; ?>'s APIs or ready-to-use plugins for platforms like WordPress, Shopify, and Magento. Detailed documentation is available on our developer portal.</p>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
      <div class="col-md-6 col-lg-5">
        <figure class="position-relative pt-md-0 pt-5" data-aos="zoom-in">
          <img loading="lazy" src="myassets/images/faqsGirl.webp" alt="IMB FAQs">
        </figure>
      </div>
    </div>
  </div>
</section>
<!-- ======== End of 1.11. FAQs section ======== -->

<!-- ======== 1.12. Footer section ======== -->
<footer>
      <div class="container">

        <div class="d-flex justify-content-between w-100">
          <div class="z-1 d-flex align-items-md-start align-items-center text-md-start text-center flex-column">
            <figure>
              <a href="index">
                <img loading="lazy" src="<?php echo $site_settings['logo_url']; ?>" alt="logo">
              </a>
            </figure>
            <p class="m-0">Free <?php echo $site_settings['brand_name']; ?> Payment API in India with, 0% Transaction charges, easy Accept payments online via UPI Qr payment and save on transaction charges. </p>

          </div>
          <div
            class="d-flex flex-column gap-lg-4 d-flex align-items-md-start align-items-center text-md-start text-center ms-0">
            <h5>Contact US</h5>
            <ul>
              <li>
                WhatsApp:
                <a href="https://wa.me/91<?php echo $site_settings['whatsapp_number']; ?>">
                  <span class="d-block">+91 <?php echo $site_settings['whatsapp_number']; ?></span></a>
              </li>
            </ul>
          </div>
          <div
            class="d-flex gap-md-3 flex-column p-0 d-flex align-items-md-start align-items-center text-md-start text-center">
            <h5>Get Started</h5>
            <p>We suggest start using today.</p>
            <div class="d-flex gap-lg-3 gap-md-3">
              <a href="auth/index">
                <div class="d-flex gap-lg-3 gap-2 justify-content-center align-items-center" style="padding-left: 20px; padding-right: 20px;">
                  <div>
                    <p>Existing user?</p>
                    <h6>Login</h6>
                  </div>
                </div>
              </a>
              <a href="register">
                <div class="d-flex gap-lg-3 gap-2 justify-content-center align-items-center" style="padding-left: 20px; padding-right: 20px;">
                  <div>
                    <p>New User?</p>
                    <h6>Register</h6>
                  </div>
                </div>
              </a>
            </div>
          </div>
        </div>
        <div class="w-100 text-center py-lg-4 py-3">
          <p>Copyright &copy; <script>document.write(new Date().getFullYear())</script> <?php echo $site_settings['brand_name']; ?> Payment. All Rights Reserved.</p>
        </div>
      </div>
      <!-- scroll to top  -->
      <div class="scrollToTop">
        <div class="arrowUp">
          <i class="fa-solid fa-arrow-up"></i>
        </div>
        <div class="water">
          <svg viewBox="0 0 560 20" class="water_wave water_wave_back">
            <use xlink:href="#wave"></use>
          </svg>
          <svg viewBox="0 0 560 20" class="water_wave water_wave_front">
            <use xlink:href="#wave"></use>
          </svg>
          <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
            viewBox="0 0 560 20" style="display: none;">
            <symbol id="wave">
              <path
                d="M420,20c21.5-0.4,38.8-2.5,51.1-4.5c13.4-2.2,26.5-5.2,27.3-5.4C514,6.5,518,4.7,528.5,2.7c7.1-1.3,17.9-2.8,31.5-2.7c0,0,0,0,0,0v20H420z">
              </path>
              <path
                d="M420,20c-21.5-0.4-38.8-2.5-51.1-4.5c-13.4-2.2-26.5-5.2-27.3-5.4C326,6.5,322,4.7,311.5,2.7C304.3,1.4,293.6-0.1,280,0c0,0,0,0,0,0v20H420z">
              </path>
              <path
                d="M140,20c21.5-0.4,38.8-2.5,51.1-4.5c13.4-2.2,26.5-5.2,27.3-5.4C234,6.5,238,4.7,248.5,2.7c7.1-1.3,17.9-2.8,31.5-2.7c0,0,0,0,0,0v20H140z">
              </path>
              <path
                d="M140,20c-21.5-0.4-38.8-2.5-51.1-4.5c-13.4-2.2-26.5-5.2-27.3-5.4C46,6.5,42,4.7,31.5,2.7C24.3,1.4,13.6-0.1,0,0c0,0,0,0,0,0l0,20H140z">
              </path>
            </symbol>
          </svg>
        </div>
      </div>
    </footer>
    <!-- ======== End of 1.12. Footer section ======== -->
  </div>
  
  
  <body oncontextmenu="return false">

  <!-- bootstrap min javascript -->
  <script src="myassets/js/bootstrap.min.js"></script>
  <!-- j Query -->
  <script src="myassets/js/jquery.js"></script>
  <!-- slick slider js -->
  <script src="myassets/js/slick.min.js"></script>
  <!-- main javascript -->
  <script src="myassets/js/custom.js"></script>
  <!-- animation from javascript -->
  <script src="myassets/js/aos.js"></script>
  
  <script disable-devtool-auto="" src="common/disable-devtool.js" data-url="https://www.google.com/"></script>

</body>

</html>