using Microsoft.AspNetCore.Mvc;

[ApiController]
[Route("[controller]")]
public class WebhookController : ControllerBase
{
    [HttpPost]
    public IActionResult ReceiveWebhook([FromForm] string status, [FromForm] string order_id, [FromForm] string remark1)
    {
        if (Request.Method != "POST")
        {
            return BadRequest("Invalid request method");
        }

        if (status == "SUCCESS")
        {
            // Process the data here as needed
            // For example, log it or perform other actions

            return Ok("Webhook received successfully");
        }
        else
        {
            // Respond with an error message if the status is not "SUCCESS"
            return BadRequest($"Invalid status: {status}");
        }
    }
}
